<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Source extends Model 
{

    protected $table = 'sources';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name_en', 'name_th');
    protected $visible = array('code', 'name_en', 'name_th');

    public function products()
    {
        return $this->hasMany('Product', 'source_id');
    }

}